<?php


class Ext_JCIndex extends W3B_Extension
{
	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('JeCat 网站首页','Ext_JCIndex',$sLanguage) ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('为服务（网站）提供缺省的首页。','Ext_JCIndex',$sLanguage) ;		
	}
	
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function GetVersion()
	{
		return new JCAT_Version(1,0,0,0,'alpha') ;
	}

	/**
	 * 取得扩展的兼容版本号
	 * 扩展自此版本以来，接口未发生任何变化，依赖此版本的其它扩展，可在当前版本上正常工作。
	 *
	 * @access	public
	 * @static 
	 * @return	void
	 */
	static public function GetCompatibleVersion()
	{
		return self::GetVersion() ;
	}
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		parent::Load($aService) ;
		
		$aRequestDispatcher = $aService->GetRequestDispatcher() ;
		$aRequestDispatcher->SetDefaultController('Ext_JCIndex_Controller') ;
	}

	
	/**
	 * 注册一个用户首页的子控制器
	 *
	 * @access	public
	 * @param	$sControllerClassName			string
	 * @param	$arrConstructArgs=array()		array
	 * @static
	 * @return	void
	 */
	static public function RegisterChildController($sControllerClassName,array $arrConstructArgs=array())
	{
		self::$arrChildControllers[$sControllerClassName] = $arrConstructArgs ;
	}
	
	/**
	 * 创建并返回所有控制器对象
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IIterator
	 */
	static public function CreateChildControllerIterator()
	{
		$arrRet = array() ;
		foreach(self::$arrChildControllers as $sClassName=>$arrArgs)
		{
			$arrRet[] = JCAT_Global::CreateObject($sClassName,$arrArgs) ;
		}
		
		return new JCAT_ArrayIterator($arrRet) ;
	}
	
	
	// 属性 ///////////////////////////
	static private $arrChildControllers = array() ;
}


?>
